﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO

Public Class ExplorerStyleViewer
    ' 声明用于保存每个自定义类的实例的变量
    Private dtvwDirectory As DirectoryTreeView
    Private flvFiles As FileListView
    Private mivChecked As MenuItemView

    ' 处理 DirectoryTreeView 的 AfterSelect 事件，这会使
    ' FileListView 对象显示选定目录的内容。
    Sub DirectoryTreeViewOnAfterSelect(ByVal obj As Object, ByVal tvea As TreeViewEventArgs)
        flvFiles.ShowFiles(tvea.Node.FullPath)
    End Sub

    ' 此子例程处理 Form Load 事件。
    Private Sub ExplorerStyleViewer_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 创建 flvFilesView 实例。
        flvFiles = New FileListView()
        SplitContainer1.Panel2.Controls.Add(flvFiles)
        flvFiles.Dock = DockStyle.Fill

        ' 创建 DirectoryTreeView 实例并添加 OnAfterSelect 事件处理程序。
        dtvwDirectory = New DirectoryTreeView()
        'dtvwDirectory.Parent = Me
        SplitContainer1.Panel1.Controls.Add(dtvwDirectory)
        dtvwDirectory.Dock = DockStyle.Left
        ' 动态添加 AfterSelect 事件处理程序。
        AddHandler dtvwDirectory.AfterSelect, _
            AddressOf DirectoryTreeViewOnAfterSelect

        ' 将“View”（视图）菜单命令添加到现有主菜单。
        Dim menuView As New ToolStripMenuItem("&View")
        MenuStrip1.Items.Add(menuView)

        ' 将四个菜单项添加到新建的“View”（视图）菜单中。从创建数组并设置
        ' 各菜单项的属性开始。
        Dim astrView As String() = {"Lar&ge Icons", "S&mall Icons", "&List", "&Details"}
        Dim aview As View() = {View.LargeIcon, View.SmallIcon, View.List, View.Details}
        ' 创建菜单项的事件处理程序。
        Dim eh As New EventHandler(AddressOf MenuOnViewSelect)

        Dim i As Integer
        For i = 0 To 3
            ' 使用自定义类 MenuItemView，该类对 MenuItem 进行了扩展以支持
            ' View 属性。
            Dim miv As New MenuItemView()
            miv.Text = astrView(i)
            miv.View = aview(i)
            miv.Checked = False
            ' 将前面创建的处理程序与 Click 事件关联。
            AddHandler miv.Click, eh

            ' 将默认视图设置为“Details”（详细资料）。
            If i = 3 Then
                mivChecked = miv
                mivChecked.Checked = True
                flvFiles.View = mivChecked.View
            End If
            ' 将新菜单项添加到“View”（视图）菜单中。
            menuView.DropDownItems.Add(miv)
        Next i
    End Sub

    ' 处理“View”（视图）菜单项的 OnViewSelect 事件。
    Sub MenuOnViewSelect(ByVal obj As Object, ByVal ea As EventArgs)
        ' 取消选中当前选择的项。
        mivChecked.Checked = False
        ' 强制转换事件发送方并选中它。
        mivChecked = CType(obj, MenuItemView)
        mivChecked.Checked = True
        ' 更改在 FileListView 控件中查看文件的方式。
        flvFiles.View = mivChecked.View
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

End Class